<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../template/stile.php";
    include "../gUtil/DbManager.php";
    include "../classi/ApiSistema.php";
    include "../classi/Immagine.php";
    include "../classi/FileScaricabile.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);	
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }
    
    $apiSistema = new ApiSistema($geecomDb);
            
    /** @TODO aggiungere codice per accettare le richeste solo dal sito corrente e non dal web */
    switch ($operazione) {
        case 'caricaImmagine': 
            // in futuro sarà il principale nodo per il caricamento di un'immagine, prenderà in input la cartella dove inserirla,
            // se non presente verrà inserita nella cartella altro
            break;
        case 'aggiornaCampoTabella':
            break;
        case 'aggiungiComponenteContenuto':
            $idContenuto  = filter_input(INPUT_POST,'idContenuto',FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $tipoElemento = filter_input(INPUT_POST,'tipoElemento',FILTER_SANITIZE_ADD_SLASHES);
            
            $apiSistema->aggiungiComponenteContenuto($idContenuto,$idComponente,$tipoElemento);
            echo "ok";
            break;
        case 'aggiungiComponenteSezioneContenuto':
            $idContenuto                    = filter_input(INPUT_POST,'idContenuto',FILTER_SANITIZE_NUMBER_INT);
            $idComponente                   = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $tabellaSezione                 = filter_input(INPUT_POST,'tabellaSezione',FILTER_SANITIZE_ADD_SLASHES);
            $idSezioneNuovoElemento         = filter_input(INPUT_POST,'idSezioneNuovoElemento',FILTER_SANITIZE_NUMBER_INT);
            $posizioneNuovoElementoSezione  = filter_input(INPUT_POST,'posizioneNuovoElementoSezione',FILTER_SANITIZE_NUMBER_INT);
            
            $apiSistema->aggiungiComponenteSezioneContenuto($idContenuto,$idComponente,$tabellaSezione,$idSezioneNuovoElemento,$posizioneNuovoElementoSezione);
            echo "ok";
            break;
        case 'modificaPosizioneComponenteContenuto':
            $idContenuto  = filter_input(INPUT_POST,'idContenuto',FILTER_SANITIZE_NUMBER_INT);
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $tipoElemento = filter_input(INPUT_POST,'tipoElemento',FILTER_SANITIZE_ADD_SLASHES);
            $posizione    = filter_input(INPUT_POST,'posizione',FILTER_SANITIZE_NUMBER_INT);
            
            $apiSistema->modificaPosizioneComponenteContenuto($idContenuto,$idComponente,$tipoElemento,$posizione);
            echo "ok";
            break;
        case 'stampaCodiceModalModificaComponenteContenuto':
            $percorsoBase = filter_input(INPUT_POST,'percorsoBase',FILTER_SANITIZE_ADD_SLASHES);
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            
            $apiSistema->stampaCodiceModalModificaComponenteContenuto($percorsoBase,$idComponente);
            break;
        case 'eliminaComponenteContenuto':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            
            $apiSistema->eliminaComponenteContenuto($idComponente);
            echo "ok";
            break;
        case 'cambiaIdElementoContenuto':
            $apiSistema->cambiaIdElementoContenuto();
            break;
        case 'cambiaIdElementoComponenteContenuto':
            $idComponente = filter_input(INPUT_GET,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            $idElemento   = filter_input(INPUT_GET,'idElemento',FILTER_SANITIZE_NUMBER_INT);
            $apiSistema->cambiaIdElementoComponenteContenuto($idComponente,$idElemento);
            echo "ok";
            break;
        case 'invertiValoreNascosto':
            $idComponente = filter_input(INPUT_POST,'idComponente',FILTER_SANITIZE_NUMBER_INT);
            
            $valoreNascostoAttuale = $apiSistema->invertiValoreNascostoComponente($idComponente);
            
            if($valoreNascostoAttuale=="si") {
                echo"Il componente ora non è visibile";
            }
            else {
                echo"Il componente è ora visibile";
            }
            break;
        case 'incrementaClickOccorrenza':
            echo "ok";
            break;
    }
    